/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting;

import com.blakebr0.cucumber.crafting.TagMapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public interface OutputResolver {
    public ItemStack resolve();

    public static Item create(RegistryFriendlyByteBuf buffer) {
        return new Item((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
    }

    public static class Item
    implements OutputResolver {
        private final ItemStack stack;

        public Item(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public ItemStack resolve() {
            return this.stack;
        }
    }

    public static class Tag
    implements OutputResolver {
        public static final MapCodec<Tag> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("tag").forGetter(result -> result.tag), (App)Codec.INT.fieldOf("count").forGetter(result -> result.count)).apply((Applicative)builder, Tag::new));
        private final String tag;
        private final int count;

        public Tag(String tag, int count) {
            this.tag = tag;
            this.count = count;
        }

        @Override
        public ItemStack resolve() {
            return TagMapper.getItemStackForTag(this.tag, this.count);
        }
    }
}

